// XISLCombOutputTag.cpp: CXISLCombOutputTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLCombOutputTag.h"
#include "XISLOutputBrowser.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CXISLCombOutputTag::CXISLCombOutputTag(CXISLTag *pParent,int nType)
{
	m_pParentTag = pParent;

	switch(nType)
	{
	case ID_TAG_SEQ:
		m_nTagType = ID_TAG_SOUTPUT;
		m_nBmpID = IDB_SEQ;
		break;
	case ID_TAG_PAR:
		m_nTagType = ID_TAG_POUTPUT;
		m_nBmpID = IDB_PAR;
		break;
	case ID_TAG_ALT:
	default:
		ASSERT(NULL);
		break;
	}
}

CXISLCombOutputTag::~CXISLCombOutputTag()
{
	for(int i=0;i<m_ActionList.GetCount();i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);
		if(pActItem->m_nTagType == ID_TAG_OUTPUT)
			delete (CXISLOutputTag*)pActItem;
		else
			delete (CXISLCombOutputTag*)pActItem;
	}
}


CXISLCombOutputTag::CXISLCombOutputTag(const CXISLCombOutputTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	for(int i=0; i<cpXISL.m_ActionList.GetCount(); i++)
	{
		POSITION pos = cpXISL.m_ActionList.FindIndex(i);
		m_ActionList.AddTail(cpXISL.m_ActionList.GetAt(pos));
	}
}

CXISLCombOutputTag& CXISLCombOutputTag::operator=(const CXISLCombOutputTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		for(int i=0;i<m_ActionList.GetCount();i++)
		{
			POSITION pos = m_ActionList.FindIndex(i);
			CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);
			if(pActItem->m_nTagType == ID_TAG_OUTPUT)
				delete (CXISLOutputTag*)pActItem;
			else
				delete (CXISLCombOutputTag*)pActItem;
		}
		m_ActionList.RemoveAll();
		for(i=0; i<cpXISL.m_ActionList.GetCount(); i++)
		{
			POSITION pos = cpXISL.m_ActionList.FindIndex(i);
			m_ActionList.AddTail(cpXISL.m_ActionList.GetAt(pos));
		}
	}
	return *this;
}

//BOOL CXISLActTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLCombOutputTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	if(m_ActionList.GetCount() == 0)
		return TRUE;

	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_ACTION];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	for(int i=0; i<m_ActionList.GetCount(); i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLActItem *pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);

		pActItem->RegistXISLTree(pTree,hParent);
	}

	return TRUE;
}

//LPCTSTR CXISLCombOutputTag::GetXISLString()
//@\@FOutputȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLCombOutputTag::GetXISLString()
{
	m_strXISL = "<";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	for(int i=0; i<m_ActionList.GetCount(); i++)
	{
		POSITION pos = m_ActionList.FindIndex(i);
		CXISLOutputTag *pOutputTag = (CXISLOutputTag*)m_ActionList.GetAt(pos);

		m_strXISL += pOutputTag->GetXISLString();
	}

	m_strXISL += "</";
	m_strXISL += XISL_TAG_NAME[m_nTagType];
	m_strXISL += ">\r\n";

	return m_strXISL;
}

//CXISLTag* CXISLCombOutputTag::FindTag(POINT point,BOOL bOnly)
//@\@FNbNꂽ^OT
//@Fpoint:W
//		  bOnly:TRUE͎̎ĝݔf
//ԂlFY^OBNULL
CXISLTag* CXISLCombOutputTag::FindTag(POINT point,BOOL bOnly)
{
	m_rectBMP.NormalizeRect();
	if(m_rectBMP.PtInRect(point))
		return (CXISLTag*)this;
	else if(!bOnly)
	{
		CXISLTag* pTag;
		for(int i=0;i<m_ActionList.GetCount();i++)
		{
			POSITION pos = m_ActionList.FindIndex(i);
			CXISLActItem* pActItem = (CXISLActItem*)m_ActionList.GetAt(pos);

			pTag = pActItem->FindTag(point,TRUE);
			if(pTag)
				return pTag;
		}
	}

	return NULL;
}
